/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.utils.HashEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeMapping {
    Entry[] table = new Entry[16];
    int size;

    public void put(Class clazz, Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.removeCached();
        Entry entry = (Entry)HashEntry.get(this.table, clazz);
        if (entry != null) {
            HashEntry.remove((HashEntry[])this.table, entry);
            --this.size;
        }
        this.insert(new Entry(clazz, value, false));
    }

    public Object get(Class clazz) {
        Entry entry = (Entry)HashEntry.get(this.table, clazz);
        if (entry != null) {
            return entry.value;
        }
        return this.slowGet(clazz);
    }

    public boolean remove(Class clazz) {
        if (HashEntry.remove((HashEntry[])this.table, clazz) != null) {
            this.removeCached();
            --this.size;
            return true;
        }
        return false;
    }

    public Set getUniqueValues() {
        HashSet<Object> result = new HashSet<Object>();
        Entry[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Entry e = arr$[i$]; e != null; e = (Entry)e.next()) {
                if (e.isCache) continue;
                result.add(e.value);
            }
        }
        return result;
    }

    public Map getEntries() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Entry[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Entry e = arr$[i$]; e != null; e = (Entry)e.next()) {
                if (e.isCache) continue;
                result.put(e.key, e.value);
            }
        }
        return result;
    }

    private Object slowGet(Class clazz) {
        Entry entry = null;
        Class baseClass = clazz;
        block0: do {
            for (Class<?> ifClass : baseClass.getInterfaces()) {
                entry = (Entry)HashEntry.get(this.table, ifClass);
                if (entry != null) break block0;
            }
        } while ((baseClass = baseClass.getSuperclass()) != null && (entry = (Entry)HashEntry.get(this.table, baseClass)) == null);
        Object value = entry != null ? entry.value : null;
        this.insert(new Entry(clazz, value, true));
        return value;
    }

    private void insert(Entry newEntry) {
        this.table = (Entry[])HashEntry.maybeResizeTable(this.table, this.size);
        HashEntry.insertEntry(this.table, newEntry);
        ++this.size;
    }

    private void removeCached() {
        for (Entry e : this.table) {
            while (e != null) {
                Entry n = (Entry)e.next();
                if (e.isCache) {
                    HashEntry.remove((HashEntry[])this.table, e);
                    --this.size;
                }
                e = n;
            }
        }
    }

    static class Entry
    extends HashEntry {
        final Object value;
        final boolean isCache;

        public Entry(Class key, Object value, boolean isCache) {
            super(key);
            this.value = value;
            this.isCache = isCache;
        }
    }
}

