/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.ClientUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.internal.EnderStorageSPH;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.item.ContainerEnderItemStorage;
import codechicken.enderstorage.storage.item.GuiEnderItemStorage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EnderItemStorage
extends AbstractEnderStorage
implements lt {
    private wm[] items;
    private int open;
    private int size = EnderItemStoragePlugin.configSize;

    public EnderItemStorage(EnderStorageManager manager, String owner, int freq) {
        super(manager, owner, freq);
        this.empty();
    }

    @Override
    public void loadFromTag(bs tag) {
        this.size = tag.c("size");
        this.empty();
        ca nbttaglist = tag.m("Items");
        int i = 0;
        while (i < nbttaglist.c()) {
            bs nbttagcompound1 = (bs)nbttaglist.b(i);
            int slot = nbttagcompound1.c("Slot") & 0xFF;
            if (slot >= 0 && slot < this.items.length) {
                this.items[slot] = wm.a((bs)nbttagcompound1);
            }
            ++i;
        }
        if (this.size != EnderItemStoragePlugin.configSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderItemStoragePlugin.configSize > this.size) {
            wm[] newItems = new wm[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderItemStoragePlugin.configSize;
            this.k_();
        } else {
            int numStacks = 0;
            wm[] wmArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                wm item = wmArray[n2];
                if (item != null) {
                    ++numStacks;
                }
                ++n2;
            }
            if (numStacks <= EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]) {
                wm[] newItems = new wm[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
                int copyTo = 0;
                wm[] wmArray2 = this.items;
                int n3 = this.items.length;
                int n4 = 0;
                while (n4 < n3) {
                    wm item = wmArray2[n4];
                    if (item != null) {
                        newItems[copyTo] = item;
                        ++copyTo;
                    }
                    ++n4;
                }
                this.items = newItems;
                this.size = EnderItemStoragePlugin.configSize;
                this.k_();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public bs saveToTag() {
        if (this.size != EnderItemStoragePlugin.configSize && this.open == 0) {
            this.alignSize();
        }
        ca nbttaglist = new ca();
        int slot = 0;
        while (slot < this.items.length) {
            if (this.items[slot] != null) {
                bs nbttagcompound1 = new bs();
                nbttagcompound1.a("Slot", (byte)slot);
                this.items[slot].b(nbttagcompound1);
                nbttaglist.a((cf)nbttagcompound1);
            }
            ++slot;
        }
        bs compound = new bs();
        compound.a("Items", (cf)nbttaglist);
        compound.a("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public wm a(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public wm b(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.getStackInSlotOnClosing((lt)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(int slot, wm stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.k_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void f() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int j_() {
        return EnderItemStoragePlugin.sizes[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public wm a(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((lt)this, (int)slot, (int)size);
        }
    }

    public String b() {
        return null;
    }

    public int d() {
        return 64;
    }

    public void k_() {
        this.setDirty();
    }

    public boolean a(sq var1) {
        return true;
    }

    public void empty() {
        this.items = new wm[this.j_()];
    }

    public void openSMPGui(sq player, final String name) {
        ServerUtils.openSMPContainer((jc)((jc)player), (tj)new ContainerEnderItemStorage((lt)player.bK, this, false), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jc player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)"ES", 2);
                packet.writeByte(windowId);
                packet.writeString(EnderItemStorage.this.owner);
                packet.writeShort(EnderItemStorage.this.freq);
                packet.writeString(name);
                packet.writeByte(EnderItemStorage.this.size);
                packet.sendToPlayer((sq)player);
            }
        });
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openClientGui(int windowID, so playerInv, String name, int size) {
        this.size = size;
        this.empty();
        ClientUtils.openSMPGui((int)windowID, (axr)new GuiEnderItemStorage(playerInv, this, name));
    }

    public boolean b(int slot, wm stack) {
        return true;
    }

    public boolean c() {
        return true;
    }
}

