/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.block.TileEntityBlock;
import ic2.core.block.invslot.InvSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileEntityInventory
extends TileEntityBlock
implements ISidedInventory {
    public final List invSlots = new ArrayList();

    @Override
    public void func_70307_a(NBTTagCompound nbtTagCompound) {
        super.func_70307_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Items")) {
            NBTTagList nbtTagList = nbtTagCompound.func_74761_m("Items");
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompoundSlot = (NBTTagCompound)nbtTagList.func_74743_b(i);
                byte slot = nbtTagCompoundSlot.func_74771_c("Slot");
                int maxOldStartIndex = -1;
                InvSlot maxSlot = null;
                for (InvSlot invSlot : this.invSlots) {
                    if (invSlot.oldStartIndex > slot || invSlot.oldStartIndex <= maxOldStartIndex) continue;
                    maxOldStartIndex = invSlot.oldStartIndex;
                    maxSlot = invSlot;
                }
                if (maxSlot == null) continue;
                int index = Math.min(slot - maxOldStartIndex, maxSlot.size() - 1);
                maxSlot.put(index, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompoundSlot));
            }
        }
        NBTTagCompound invSlotsTag = nbtTagCompound.func_74775_l("InvSlots");
        for (InvSlot invSlot : this.invSlots) {
            invSlot.readFromNbt(invSlotsTag.func_74775_l(invSlot.name));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTagCompound) {
        super.func_70310_b(nbtTagCompound);
        NBTTagCompound invSlotsTag = new NBTTagCompound();
        for (InvSlot invSlot : this.invSlots) {
            NBTTagCompound invSlotTag = new NBTTagCompound();
            invSlot.writeToNbt(invSlotTag);
            invSlotsTag.func_74782_a(invSlot.name, (NBTBase)invSlotTag);
        }
        nbtTagCompound.func_74782_a("InvSlots", (NBTBase)invSlotsTag);
    }

    public int func_70302_i_() {
        int ret = 0;
        for (InvSlot invSlot : this.invSlots) {
            ret += invSlot.size();
        }
        return ret;
    }

    public ItemStack func_70301_a(int index) {
        for (InvSlot invSlot : this.invSlots) {
            if (index < invSlot.size()) {
                return invSlot.get(index);
            }
            index -= invSlot.size();
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemStack = this.func_70301_a(index);
        if (itemStack == null) {
            return null;
        }
        if (amount >= itemStack.field_77994_a) {
            this.func_70299_a(index, null);
            return itemStack;
        }
        itemStack.field_77994_a -= amount;
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = amount;
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack ret = this.func_70301_a(index);
        if (ret != null) {
            this.func_70299_a(index, null);
        }
        return ret;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        for (InvSlot invSlot : this.invSlots) {
            if (index < invSlot.size()) {
                invSlot.put(index, itemStack);
                break;
            }
            index -= invSlot.size();
        }
    }

    public abstract String func_70303_b();

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70011_f((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        InvSlot invSlot = this.getInvSlot(index);
        return invSlot != null && invSlot.canInput() && invSlot.accepts(itemStack);
    }

    public int[] func_94128_d(int var1) {
        int[] ret = new int[this.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public boolean func_102007_a(int index, ItemStack itemStack, int side) {
        InvSlot targetSlot = this.getInvSlot(index);
        if (targetSlot == null) {
            return false;
        }
        if (!targetSlot.canInput() || !targetSlot.accepts(itemStack)) {
            return false;
        }
        if (targetSlot.preferredSide != InvSlot.InvSide.ANY && targetSlot.preferredSide.matches(side)) {
            return true;
        }
        for (InvSlot invSlot : this.invSlots) {
            if (invSlot == targetSlot || invSlot.preferredSide == InvSlot.InvSide.ANY || !invSlot.preferredSide.matches(side) || !invSlot.canInput() || !invSlot.accepts(itemStack)) continue;
            return false;
        }
        return true;
    }

    public boolean func_102008_b(int index, ItemStack itemStack, int side) {
        InvSlot targetSlot = this.getInvSlot(index);
        if (targetSlot == null) {
            return false;
        }
        if (!targetSlot.canOutput()) {
            return false;
        }
        if (targetSlot.preferredSide != InvSlot.InvSide.ANY && targetSlot.preferredSide.matches(side)) {
            return true;
        }
        for (InvSlot invSlot : this.invSlots) {
            if (invSlot == targetSlot || invSlot.preferredSide == InvSlot.InvSide.ANY || !invSlot.preferredSide.matches(side) || !invSlot.canOutput()) continue;
            return false;
        }
        return true;
    }

    public void addInvSlot(InvSlot invSlot) {
        this.invSlots.add(invSlot);
    }

    private InvSlot getInvSlot(int index) {
        for (InvSlot invSlot : this.invSlots) {
            if (index < invSlot.size()) {
                return invSlot;
            }
            index -= invSlot.size();
        }
        return null;
    }
}

