/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.Recipes;
import ic2.core.BasicListRecipeManager;
import ic2.core.Ic2Items;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.machine.ContainerStandardMachine;
import ic2.core.block.machine.gui.GuiRecycler;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class TileEntityRecycler
extends TileEntityStandardMachine {
    public TileEntityRecycler() {
        super(1, 45);
        this.inputSlot = new InvSlot(this, "input", 0, InvSlot.Access.I, 1, InvSlot.InvSide.TOP);
    }

    public static void init(Configuration config) {
        Recipes.recyclerBlacklist = new BasicListRecipeManager();
        Recipes.recyclerBlacklist.add(new ItemStack(Block.field_72003_bq));
        Recipes.recyclerBlacklist.add(new ItemStack(Item.field_77669_D));
        Recipes.recyclerBlacklist.add(new ItemStack(Item.field_77768_aD));
        Recipes.recyclerBlacklist.add(Ic2Items.scaffold);
        if (config != null) {
            Property prop = config.get("general", "recyclerBlacklist", TileEntityRecycler.getRecyclerBlacklistString());
            prop.comment = "List of blocks and items which should not be turned into scrap by the recycler. Comma separated, format is id-metadata";
            TileEntityRecycler.setRecyclerBlacklistFromString(prop.getString());
        }
    }

    @Override
    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        boolean itemBlacklisted = TileEntityRecycler.getIsItemBlacklisted(this.inputSlot.get());
        --this.inputSlot.get().field_77994_a;
        if (this.inputSlot.get().field_77994_a <= 0) {
            this.inputSlot.clear();
        }
        if (this.field_70331_k.field_73012_v.nextInt(TileEntityRecycler.recycleChance()) == 0 && !itemBlacklisted) {
            this.outputSlot.add(Ic2Items.scrap.func_77946_l());
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inputSlot.isEmpty()) {
            return false;
        }
        return this.outputSlot.canAdd(Ic2Items.scrap);
    }

    @Override
    public ItemStack getResultFor(ItemStack itemstack, boolean adjustInput) {
        return null;
    }

    @Override
    public String func_70303_b() {
        return "Recycler";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiRecycler(new ContainerStandardMachine(entityPlayer, this));
    }

    public static int recycleChance() {
        return 8;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/RecyclerOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    public static boolean getIsItemBlacklisted(ItemStack itemStack) {
        return Recipes.recyclerBlacklist.contains(itemStack);
    }

    private static String getRecyclerBlacklistString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (ItemStack entry : Recipes.recyclerBlacklist) {
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(entry.field_77993_c);
            if (entry.func_77960_j() == 0) continue;
            ret.append("-");
            ret.append(entry.func_77960_j());
        }
        return ret.toString();
    }

    private static void setRecyclerBlacklistFromString(String str) {
        String[] strParts;
        for (String strPart : strParts = str.trim().split("\\s*,\\s*")) {
            String[] idMeta = strPart.split("\\s*-\\s*");
            if (idMeta[0].length() == 0) continue;
            int blockId = Integer.parseInt(idMeta[0]);
            int metaData = Short.MAX_VALUE;
            if (idMeta.length == 2) {
                metaData = Integer.parseInt(idMeta[1]);
            }
            ItemStack is = new ItemStack(blockId, 1, metaData);
            Recipes.recyclerBlacklist.add(is);
        }
    }
}

