/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.registry.LanguageRegistry;
import ic2.core.IC2;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Localization {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File modSourceFile) {
        if (modSourceFile.isDirectory()) {
            File langFolder = new File(modSourceFile, "ic2/lang");
            if (langFolder.isDirectory()) {
                for (File langFile : langFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".properties");
                    }
                })) {
                    try {
                        Localization.loadLocalization(langFile.toURI().toURL().openStream(), langFile.getName().split("\\.")[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IC2.log.warning("can't read language file");
                    }
                }
            } else {
                IC2.log.warning("can't list language files (from folder)");
            }
        } else if (modSourceFile.exists() && modSourceFile.getName().endsWith(".jar")) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(modSourceFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("ic2/lang/") || (name = name.substring("ic2/lang/".length())).contains("/") || !name.endsWith(".properties")) continue;
                    Localization.loadLocalization(zipFile.getInputStream(entry), name.split("\\.")[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                IC2.log.warning("can't list language files (from jar)");
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            IC2.log.warning("can't find language files");
        }
    }

    public static void loadLocalization(InputStream inputStream, String lang) throws IOException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, Charsets.UTF_8));
        for (Map.Entry<Object, Object> entries : properties.entrySet()) {
            Object key = entries.getKey();
            Object value = entries.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            String newKey = (String)key;
            if (!newKey.startsWith("achievement.") && !newKey.startsWith("itemGroup.")) {
                newKey = "ic2." + newKey;
            }
            LanguageRegistry.instance().addStringLocalization(newKey, lang, (String)value);
        }
    }

    public static void addLocalization(String name, String desc) {
        LanguageRegistry.instance().addStringLocalization(name, desc);
    }
}

