/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.init.InternalName;
import ic2.core.item.InfiniteElectricItemManager;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemDebug
extends ItemIC2
implements ISpecialElectricItem {
    private static final String[] modes = new String[]{"Interfaces and Fields", "Tile Data"};
    private static IElectricItemManager manager = null;

    public ItemDebug(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77627_a(false);
        if (!Util.inDev()) {
            this.func_77637_a(null);
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "debugItem";
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        int mode = nbtData.func_74762_e("mode");
        if (player.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                mode = (mode + 1) % modes.length;
                nbtData.func_74768_a("mode", mode);
                IC2.platform.messagePlayer(player, "Debug Item Mode: " + modes[mode]);
            }
            return false;
        }
        switch (mode) {
            case 0: {
                PrintStream ps = new PrintStream(new FileOutputStream(FileDescriptor.out));
                int blockId = world.func_72798_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                TileEntity tileEntity = world.func_72796_p(x, y, z);
                String plat = IC2.platform.isRendering() ? (IC2.platform.isSimulating() ? "sp" : "client") : "server";
                String message = blockId < Block.field_71973_m.length && Block.field_71973_m[blockId] != null ? "[" + plat + "] id: " + blockId + " meta: " + meta + " name: " + Block.field_71973_m[blockId].func_71917_a() + " te: " + tileEntity : "[" + plat + "] id: " + blockId + " meta: " + meta + " name: null te: " + tileEntity;
                IC2.platform.messagePlayer(player, message);
                ps.println(message);
                if (tileEntity != null) {
                    message = "[" + plat + "] interfaces:";
                    Class<?> c = tileEntity.getClass();
                    do {
                        for (Class<?> i : c.getInterfaces()) {
                            message = message + " " + i.getName();
                        }
                    } while ((c = c.getSuperclass()) != null);
                    IC2.platform.messagePlayer(player, message);
                    ps.println(message);
                }
                if (blockId < Block.field_71973_m.length && Block.field_71973_m[blockId] != null && Block.field_71973_m[blockId].field_71990_ca != 0) {
                    ps.println("block fields:");
                    ItemDebug.dumpObjectFields(ps, Block.field_71973_m[blockId]);
                }
                if (tileEntity != null) {
                    ps.println("tile entity fields:");
                    ItemDebug.dumpObjectFields(ps, tileEntity);
                }
                ps.flush();
                break;
            }
            case 1: {
                Object te;
                if (!IC2.platform.isSimulating()) {
                    return false;
                }
                TileEntity tileEntity = world.func_72796_p(x, y, z);
                if (tileEntity instanceof TileEntityBlock) {
                    te = (TileEntityBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "Block: Active=" + ((TileEntityBlock)te).getActive() + " Facing=" + ((TileEntityBlock)te).getFacing());
                }
                if (tileEntity instanceof TileEntityBaseGenerator) {
                    te = (TileEntityBaseGenerator)tileEntity;
                    IC2.platform.messagePlayer(player, "BaseGen: Fuel=" + ((TileEntityBaseGenerator)te).fuel + " Storage=" + ((TileEntityBaseGenerator)te).storage);
                }
                if (tileEntity instanceof TileEntityElectricMachine) {
                    te = (TileEntityElectricMachine)tileEntity;
                    IC2.platform.messagePlayer(player, "ElecMachine: Energy=" + ((TileEntityElectricMachine)te).energy);
                }
                if (tileEntity instanceof IEnergyStorage) {
                    te = (IEnergyStorage)tileEntity;
                    IC2.platform.messagePlayer(player, "EnergyStorage: Stored=" + te.getStored());
                }
                if (tileEntity instanceof IReactor) {
                    te = (IReactor)tileEntity;
                    IC2.platform.messagePlayer(player, "Reactor: Heat=" + te.getHeat() + " MaxHeat=" + te.getMaxHeat() + " HEM=" + te.getHeatEffectModifier() + " Output=" + te.getOutput());
                }
                if (tileEntity instanceof IPersonalBlock) {
                    te = (IPersonalBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "PersonalBlock: CanAccess=" + te.permitsAccess(player));
                }
                if (!(tileEntity instanceof TileEntityCrop)) break;
                te = (TileEntityCrop)tileEntity;
                IC2.platform.messagePlayer(player, "PersonalBlock: Crop=" + ((TileEntityCrop)te).id + " Size=" + ((TileEntityCrop)te).size + " Growth=" + ((TileEntityCrop)te).statGrowth + " Gain=" + ((TileEntityCrop)te).statGain + " Resistance=" + ((TileEntityCrop)te).statResistance + " Nutrients=" + ((TileEntityCrop)te).nutrientStorage + " Water=" + ((TileEntityCrop)te).waterStorage + " GrowthPoints=" + ((TileEntityCrop)te).growthPoints);
                break;
            }
        }
        return IC2.platform.isSimulating();
    }

    private static void dumpObjectFields(PrintStream ps, Object o) {
        Class<?> fieldDeclaringClass = o.getClass();
        do {
            Field[] fields;
            for (Field field : fields = fieldDeclaringClass.getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0 && (fieldDeclaringClass == Block.class || fieldDeclaringClass == TileEntity.class)) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    ArrayList<Object> value = field.get(o);
                    ps.println(field.getName() + " class: " + fieldDeclaringClass.getName() + " type: " + field.getType());
                    ps.println("    identity hash: " + System.identityHashCode(o) + " hash: " + o.hashCode() + " modifiers: " + field.getModifiers());
                    if (field.getType().isArray()) {
                        ArrayList<Object> array = new ArrayList<Object>();
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            array.add(Array.get(value, i));
                        }
                        value = array;
                    }
                    if (value instanceof Iterable) {
                        ps.println("    values:");
                        int i = 0;
                        Iterator it = ((Iterable)value).iterator();
                        while (it.hasNext()) {
                            ps.println("      [" + i + "] " + ItemDebug.getValueString(it.next()));
                            ++i;
                        }
                    } else {
                        ps.println("    value: " + ItemDebug.getValueString(value));
                    }
                }
                catch (IllegalAccessException e) {
                    ps.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: <can't access>");
                }
                catch (NullPointerException e) {
                    ps.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: <null>");
                }
                field.setAccessible(accessible);
            }
        } while ((fieldDeclaringClass = fieldDeclaringClass.getSuperclass()) != null);
    }

    private static String getValueString(Object o) {
        if (o == null) {
            return "<null>";
        }
        String ret = o.toString();
        if (o.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                ret = ret + " [" + i + "] " + Array.get(o, i);
            }
        }
        if (ret.length() > 100) {
            ret = ret.substring(0, 90) + "... (" + ret.length() + " more)";
        }
        return ret;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        if (manager == null) {
            manager = new InfiniteElectricItemManager();
        }
        return manager;
    }
}

