/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkItemEventListener;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.util.StackUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemToolMiningLaser
extends ItemElectricTool
implements INetworkItemEventListener {
    private static final int EventShotMining = 0;
    private static final int EventShotLowFocus = 1;
    private static final int EventShotLongRange = 2;
    private static final int EventShotHorizontal = 3;
    private static final int EventShotSuperHeat = 4;
    private static final int EventShotScatter = 5;
    private static final int EventShotExplosive = 6;

    public ItemToolMiningLaser(Configuration config, InternalName internalName) {
        super(config, internalName, EnumToolMaterial.IRON, 100);
        this.maxCharge = 200000;
        this.transferLimit = 120;
        this.tier = 2;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemstack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
        int laserSetting = nbtData.func_74762_e("laserSetting");
        if (IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            laserSetting = (laserSetting + 1) % 7;
            nbtData.func_74768_a("laserSetting", laserSetting);
            String laser = (new String[]{"Mining", "Low-Focus", "Long-Range", "Horizontal", "Super-Heat", "Scatter", "Explosive"})[laserSetting];
            IC2.platform.messagePlayer(entityplayer, "Laser Mode: " + laser);
        } else {
            int consume = (new int[]{1250, 100, 5000, 0, 2500, 10000, 5000})[laserSetting];
            if (!ElectricItem.manager.use(itemstack, consume, (EntityLiving)entityplayer)) {
                return itemstack;
            }
            switch (laserSetting) {
                case 0: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 0, true);
                    break;
                }
                case 1: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, 4.0f, 5.0f, 1, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 1, true);
                    break;
                }
                case 2: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, Float.POSITIVE_INFINITY, 20.0f, Integer.MAX_VALUE, false));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 2, true);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, Float.POSITIVE_INFINITY, 8.0f, Integer.MAX_VALUE, false, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 4, true);
                    break;
                }
                case 5: {
                    for (int x = -2; x <= 2; ++x) {
                        for (int y = -2; y <= 2; ++y) {
                            world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, false, entityplayer.field_70177_z + 20.0f * (float)x, entityplayer.field_70125_A + 20.0f * (float)y));
                        }
                    }
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 5, true);
                    break;
                }
                case 6: {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityplayer, Float.POSITIVE_INFINITY, 12.0f, Integer.MAX_VALUE, true));
                    IC2.network.initiateItemEvent(entityplayer, itemstack, 6, true);
                }
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
        if (!IC2.keyboard.isModeSwitchKeyDown(entityPlayer) && nbtData.func_74762_e("laserSetting") == 3) {
            if (Math.abs(entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e() - 0.1 - ((double)y + 0.5)) < 1.5) {
                if (ElectricItem.manager.use(itemstack, 3000, (EntityLiving)entityPlayer)) {
                    world.func_72838_d((Entity)new EntityMiningLaser(world, (EntityLiving)entityPlayer, Float.POSITIVE_INFINITY, 5.0f, Integer.MAX_VALUE, false, entityPlayer.field_70177_z, 0.0, (double)y + 0.5));
                    IC2.network.initiateItemEvent(entityPlayer, itemstack, 3, true);
                }
            } else {
                IC2.platform.messagePlayer(entityPlayer, "Mining laser aiming angle too steep");
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @Override
    public void onNetworkEvent(int metaData, EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 1: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLowFocus.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 2: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserLongRange.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 3: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 4: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaser.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 5: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserScatter.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            case 6: {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/MiningLaser/MiningLaserExplosive.ogg", true, IC2.audioManager.defaultVolume);
            }
        }
    }
}

