/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PowerFramework {
    private static String baseNBTName = "net.minecraft.src.buildcarft.Power";
    public static PowerFramework currentFramework;

    public abstract IPowerProvider createPowerProvider();

    public void loadPowerProvider(IPowerReceptor receptor, NBTTagCompound compound) {
        NBTTagCompound cpt;
        IPowerProvider provider = this.createPowerProvider();
        if (compound.func_74764_b(baseNBTName) && (cpt = compound.func_74775_l(baseNBTName)).func_74779_i("class").equals(this.getClass().getName())) {
            provider.readFromNBT(cpt.func_74775_l("contents"));
        }
        receptor.setPowerProvider(provider);
    }

    public void savePowerProvider(IPowerReceptor receptor, NBTTagCompound compound) {
        IPowerProvider provider = receptor.getPowerProvider();
        if (provider == null) {
            return;
        }
        NBTTagCompound cpt = new NBTTagCompound();
        cpt.func_74778_a("class", this.getClass().getName());
        NBTTagCompound contents = new NBTTagCompound();
        provider.writeToNBT(contents);
        cpt.func_74782_a("contents", (NBTBase)contents);
        compound.func_74782_a(baseNBTName, (NBTBase)cpt);
    }
}

