/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public final class TileBuffer {
    private int blockID = 0;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker();
    private final World world;
    final int x;
    final int y;
    final int z;
    private final boolean loadUnloaded;

    public TileBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public final void refresh() {
        this.tile = null;
        this.blockID = 0;
        if (!this.loadUnloaded && !this.world.func_72899_e(this.x, this.y, this.z)) {
            return;
        }
        this.blockID = this.world.func_72798_a(this.x, this.y, this.z);
        Block block = Block.field_71973_m[this.blockID];
        if (block != null && block.hasTileEntity(this.world.func_72805_g(this.x, this.y, this.z))) {
            this.tile = this.world.func_72796_p(this.x, this.y, this.z);
        }
    }

    public void set(int blockID, TileEntity tile) {
        this.blockID = blockID;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public int getBlockID() {
        if (this.tile != null && !this.tile.func_70320_p()) {
            return this.blockID;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_70320_p()) {
                return this.blockID;
            }
        }
        return 0;
    }

    public TileEntity getTile() {
        if (this.tile != null && !this.tile.func_70320_p()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world, 20L)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_70320_p()) {
                return this.tile;
            }
        }
        return null;
    }

    public static TileBuffer[] makeBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            buffer[i] = new TileBuffer(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, loadUnloaded);
        }
        return buffer;
    }
}

