/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class InvUtils {
    public static int countItems(IInventory inv, ForgeDirection side, ItemStack ... filter) {
        return InvUtils.countItems(inv, side, new ArrayStackFilter(filter));
    }

    public static int countItems(IInventory inv, ForgeDirection side, IStackFilter filter) {
        int count = 0;
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, ItemStack ... filter) {
        return InvUtils.containsItem(inv, side, new ArrayStackFilter(filter));
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, IStackFilter filter) {
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoomForStack(ItemStack stack, ForgeDirection side, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        ITransactor tran = Transactor.getTransactorFor(dest);
        return tran.add((ItemStack)stack, (ForgeDirection)side, (boolean)false).field_77994_a > 0;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, IStackFilter filter) {
        ITransactor imSource = Transactor.getTransactorFor(source);
        ItemStack stack = imSource.remove(filter, output, false);
        if (stack != null) {
            ITransactor imDest = Transactor.getTransactorFor(dest);
            int moved = imDest.add((ItemStack)stack, (ForgeDirection)intput, (boolean)true).field_77994_a;
            if (moved > 0) {
                imSource.remove(filter, output, true);
                return stack;
            }
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, ItemStack ... filter) {
        return InvUtils.moveOneItem(source, output, dest, intput, new ArrayStackFilter(filter));
    }
}

