/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TriggerLiquidContainer
extends BCTrigger {
    public State state;

    public TriggerLiquidContainer(int id, State state) {
        super(id);
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Tank Empty";
            }
            case Contains: {
                return "Liquid in Tank";
            }
            case Space: {
                return "Space for Liquid";
            }
        }
        return "Tank Full";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof ITankContainer) {
            ILiquidTank[] liquids;
            ITankContainer container = (ITankContainer)tile;
            LiquidStack searchedLiquid = null;
            if (parameter != null && parameter.getItem() != null) {
                searchedLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)parameter.getItem());
            }
            if (searchedLiquid != null) {
                searchedLiquid.amount = 1;
            }
            if ((liquids = container.getTanks(ForgeDirection.UNKNOWN)) == null || liquids.length == 0) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    for (ILiquidTank c : liquids) {
                        LiquidStack drained;
                        if (!(searchedLiquid != null ? (drained = c.drain(1, false)) != null && searchedLiquid.isLiquidEqual(drained) : c.getLiquid() != null && c.getLiquid().amount > 0)) continue;
                        return false;
                    }
                    return true;
                }
                case Contains: {
                    for (ILiquidTank c : liquids) {
                        if (c.getLiquid() == null || c.getLiquid().amount == 0 || searchedLiquid != null && !searchedLiquid.isLiquidEqual(c.getLiquid())) continue;
                        return true;
                    }
                    return false;
                }
                case Space: {
                    for (ILiquidTank c : liquids) {
                        if (!(searchedLiquid != null ? c.fill(searchedLiquid, false) > 0 : c.getLiquid() == null || c.getLiquid().amount < c.getCapacity())) continue;
                        return true;
                    }
                    return false;
                }
                case Full: {
                    for (ILiquidTank c : liquids) {
                        if (!(searchedLiquid != null ? c.fill(searchedLiquid, false) > 0 : c.getLiquid() == null || c.getLiquid().amount < c.getCapacity())) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Empty: {
                return 11;
            }
            case Contains: {
                return 12;
            }
            case Space: {
                return 13;
            }
        }
        return 14;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

