/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class PumpDimensionList {
    private List entries = new LinkedList();

    public PumpDimensionList(String string) {
        for (String entryString : string.trim().split(",")) {
            Entry e = new Entry();
            if (entryString.startsWith("+/")) {
                e.isWhitelist = true;
            } else if (entryString.startsWith("-/")) {
                e.isWhitelist = false;
            } else {
                throw new RuntimeException("Malformed pumping.controlList entry: " + entryString + " (must start with +/ or -/)");
            }
            entryString = entryString.substring(2);
            int i = entryString.indexOf(47);
            if (i < 0) {
                throw new RuntimeException("Malformed pumping.controlList entry: " + entryString + " (missing second /)");
            }
            String dimIDString = entryString.substring(0, i);
            if (dimIDString.equals("*")) {
                e.matchAnyDim = true;
            } else {
                e.dimID = Integer.parseInt(dimIDString);
            }
            e.liquidName = entryString.substring(i + 1);
            if (e.liquidName.equals("*")) {
                e.matchAnyLiquid = true;
            }
            this.entries.add(0, e);
        }
        this.entries = new ArrayList(this.entries);
    }

    public boolean isLiquidAllowed(LiquidStack liquid, int dim) {
        for (Entry e : this.entries) {
            if (!e.matches(liquid, dim)) continue;
            return e.isWhitelist;
        }
        return false;
    }

    private class Entry {
        boolean isWhitelist;
        LiquidStack liquidStack;
        String liquidName;
        int dimID;
        boolean matchAnyLiquid;
        boolean matchAnyDim;

        private Entry() {
        }

        private void initLiquidStack() {
            this.liquidStack = LiquidDictionary.getLiquid((String)this.liquidName, (int)1);
            if (this.liquidStack == null) {
                throw new RuntimeException("Configuration error: unknown liquid " + this.liquidName + " in pumping.controlList");
            }
        }

        boolean matches(LiquidStack liquid, int dim) {
            if (!this.matchAnyLiquid) {
                if (this.liquidStack == null) {
                    this.initLiquidStack();
                }
                if (!this.liquidStack.isLiquidEqual(liquid)) {
                    return false;
                }
            }
            return this.matchAnyDim || this.dimID == dim;
        }
    }
}

