/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.gui.ContainerRefinery;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class GuiRefinery
extends GuiAdvancedInterface {
    ContainerRefinery container;

    public GuiRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(new ContainerRefinery(inventory, refinery), refinery);
        this.field_74194_b = 175;
        this.field_74195_c = 207;
        this.container = (ContainerRefinery)this.field_74193_d;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[3];
        this.slots[0] = new GuiAdvancedInterface.ItemSlot(38, 54);
        this.slots[1] = new GuiAdvancedInterface.ItemSlot(126, 54);
        this.slots[2] = new GuiAdvancedInterface.ItemSlot(82, 54);
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        String title = StringUtils.localize("tile.refineryBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_73886_k.func_78276_b("->", 63, 59, 0x404040);
        this.field_73886_k.func_78276_b("<-", 106, 59, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(DefaultProps.TEXTURE_PATH_GUI + "/refinery_filter.png");
        int j = (this.field_73880_f - this.field_74194_b) / 2;
        int k = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_74194_b, this.field_74195_c);
        this.updateSlots();
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        GuiAdvancedInterface.AdvancedSlot slot = null;
        if (position != -1 && position != 2) {
            slot = this.slots[position];
        }
        if (slot != null) {
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.field_73882_e.field_71439_g.field_71071_by.func_70445_o());
            if (liquid == null) {
                return;
            }
            this.container.setFilter(position, liquid.itemID, liquid.itemMeta);
        }
    }

    private void updateSlots() {
        RefineryRecipe recipe;
        ItemStack filter0 = this.container.getFilter(0);
        ItemStack filter1 = this.container.getFilter(1);
        ((GuiAdvancedInterface.ItemSlot)this.slots[0]).stack = filter0;
        ((GuiAdvancedInterface.ItemSlot)this.slots[1]).stack = filter1;
        LiquidStack liquid0 = null;
        LiquidStack liquid1 = null;
        if (filter0 != null) {
            liquid0 = new LiquidStack(filter0.field_77993_c, 1000, filter0.func_77960_j());
        }
        if (filter1 != null) {
            liquid1 = new LiquidStack(filter1.field_77993_c, 1000, filter1.func_77960_j());
        }
        ((GuiAdvancedInterface.ItemSlot)this.slots[2]).stack = (recipe = RefineryRecipe.findRefineryRecipe(liquid0, liquid1)) != null ? recipe.result.asItemStack() : null;
    }
}

