/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.gates.IAction;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.network.PacketNBT;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.ILaserTarget;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileAssemblyTable
extends TileEntity
implements IMachine,
IInventory,
IPipeConnection,
ILaserTarget {
    ItemStack[] items = new ItemStack[12];
    LinkedHashSet plannedOutput = new LinkedHashSet();
    public AssemblyRecipe currentRecipe;
    private float currentRequiredEnergy = 0.0f;
    private float energyStored = 0.0f;
    private float[] recentEnergy = new float[20];
    private int tick = 0;
    private int recentEnergyAverage;

    public LinkedList getPotentialOutputs() {
        LinkedList<AssemblyRecipe> result = new LinkedList<AssemblyRecipe>();
        for (AssemblyRecipe recipe : AssemblyRecipe.assemblyRecipes) {
            if (!recipe.canBeDone(this.items)) continue;
            result.add(recipe);
        }
        return result;
    }

    @Override
    public void receiveLaserEnergy(float energy) {
        this.energyStored += energy;
        int n = this.tick;
        this.recentEnergy[n] = this.recentEnergy[n] + energy;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_70316_g() {
        ++this.tick;
        this.tick %= this.recentEnergy.length;
        this.recentEnergy[this.tick] = 0.0f;
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeDone(this.items)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.energyStored >= this.currentRecipe.energy) {
            this.energyStored = 0.0f;
            if (this.currentRecipe.canBeDone(this.items)) {
                block0: for (ItemStack in : this.currentRecipe.input) {
                    if (in == null) continue;
                    int found = 0;
                    for (int i = 0; i < this.items.length; ++i) {
                        if (this.items[i] == null || !StackHelper.instance().isCraftingEquivalent(in, this.items[i], true)) continue;
                        int supply = this.items[i].field_77994_a;
                        int toBeFound = in.field_77994_a - found;
                        found = supply >= toBeFound ? (found += this.func_70298_a((int)i, (int)toBeFound).field_77994_a) : (found += this.func_70298_a((int)i, (int)supply).field_77994_a);
                        if (found >= in.field_77994_a) continue block0;
                    }
                }
                ItemStack remaining = this.currentRecipe.output.func_77946_l();
                ItemStack added = Utils.addToRandomInventory(remaining, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                remaining.field_77994_a -= added.field_77994_a;
                if (remaining.field_77994_a > 0) {
                    Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining.field_77994_a > 0) {
                    EntityItem entityitem = new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.7, (double)this.field_70327_n + 0.5, this.currentRecipe.output.func_77946_l());
                    this.field_70331_k.func_72838_d((Entity)entityitem);
                }
                this.setNextCurrentRecipe();
            }
        }
    }

    public float getCompletionRatio(float ratio) {
        if (this.currentRecipe == null) {
            return 0.0f;
        }
        if (this.energyStored >= this.currentRequiredEnergy) {
            return ratio;
        }
        return this.energyStored / this.currentRequiredEnergy * ratio;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.items[i].func_77979_a(j);
        if (this.items[i].field_77994_a == 0) {
            this.items[i] = null;
        }
        return stack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        ItemStack stackToTake = this.items[slot];
        this.items[slot] = null;
        return stackToTake;
    }

    public String func_70303_b() {
        return "Assembly Table";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "items", this.items);
        this.energyStored = nbttagcompound.func_74760_g("energyStored");
        NBTTagList list = nbttagcompound.func_74761_m("planned");
        block0: for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cpt = (NBTTagCompound)list.func_74743_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)cpt);
            for (AssemblyRecipe r : AssemblyRecipe.assemblyRecipes) {
                if (r.output.field_77993_c != stack.field_77993_c || r.output.func_77960_j() != stack.func_77960_j()) continue;
                this.plannedOutput.add(r);
                continue block0;
            }
        }
        if (nbttagcompound.func_74764_b("recipe")) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("recipe"));
            for (AssemblyRecipe r : this.plannedOutput) {
                if (r.output.field_77993_c != stack.field_77993_c || r.output.func_77960_j() != stack.func_77960_j()) continue;
                this.setCurrentRecipe(r);
                break;
            }
        }
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "items", this.items);
        nbttagcompound.func_74776_a("energyStored", this.energyStored);
        NBTTagList list = new NBTTagList();
        for (AssemblyRecipe recipe : this.plannedOutput) {
            NBTTagCompound cpt = new NBTTagCompound();
            recipe.output.func_77955_b(cpt);
            list.func_74742_a((NBTBase)cpt);
        }
        nbttagcompound.func_74782_a("planned", (NBTBase)list);
        if (this.currentRecipe != null) {
            NBTTagCompound recipe = new NBTTagCompound();
            this.currentRecipe.output.func_77955_b(recipe);
            nbttagcompound.func_74782_a("recipe", (NBTBase)recipe);
        }
    }

    public boolean isPlanned(AssemblyRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return this.plannedOutput.contains(recipe);
    }

    public boolean isAssembling(AssemblyRecipe recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(AssemblyRecipe recipe) {
        this.currentRecipe = recipe;
        this.currentRequiredEnergy = recipe != null ? recipe.energy : 0.0f;
    }

    public void planOutput(AssemblyRecipe recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe);
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
        }
    }

    public void cancelPlanOutput(AssemblyRecipe recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe);
        if (!this.plannedOutput.isEmpty()) {
            this.setCurrentRecipe((AssemblyRecipe)this.plannedOutput.iterator().next());
        }
    }

    public void setNextCurrentRecipe() {
        boolean takeNext = false;
        for (AssemblyRecipe recipe : this.plannedOutput) {
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeDone(this.items)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (AssemblyRecipe recipe : this.plannedOutput) {
            if (!recipe.canBeDone(this.items)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    public void handleSelectionMessage(SelectionMessage message) {
        for (AssemblyRecipe recipe : AssemblyRecipe.assemblyRecipes) {
            if (!recipe.output.func_77969_a(message.stack) || !ItemStack.func_77970_a((ItemStack)recipe.output, (ItemStack)message.stack)) continue;
            if (message.select) {
                this.planOutput(recipe);
                break;
            }
            this.cancelPlanOutput(recipe);
            break;
        }
    }

    public void sendSelectionTo(EntityPlayer player) {
        for (AssemblyRecipe r : AssemblyRecipe.assemblyRecipes) {
            SelectionMessage message = new SelectionMessage();
            message.stack = r.output;
            message.select = this.isPlanned(r);
            PacketNBT packet = new PacketNBT(22, message.getNBT(), this.field_70329_l, this.field_70330_m, this.field_70327_n);
            packet.posX = this.field_70329_l;
            packet.posY = this.field_70330_m;
            packet.posZ = this.field_70327_n;
            CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.field_70331_k, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    public void getGUINetworkData(int i, int j) {
        int currentStored = (int)((double)this.energyStored * 100.0);
        int requiredEnergy = (int)((double)this.currentRequiredEnergy * 100.0);
        switch (i) {
            case 0: {
                requiredEnergy = requiredEnergy & 0xFFFF0000 | j & 0xFFFF;
                this.currentRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 1: {
                currentStored = currentStored & 0xFFFF0000 | j & 0xFFFF;
                this.energyStored = (float)currentStored / 100.0f;
                break;
            }
            case 2: {
                requiredEnergy = requiredEnergy & 0xFFFF | (j & 0xFFFF) << 16;
                this.currentRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 3: {
                currentStored = currentStored & 0xFFFF | (j & 0xFFFF) << 16;
                this.energyStored = (float)currentStored / 100.0f;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | j & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (j & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int requiredEnergy = (int)((double)this.currentRequiredEnergy * 100.0);
        int currentStored = (int)((double)this.energyStored * 100.0);
        int lRecentEnergy = 0;
        for (int i = 0; i < this.recentEnergy.length; ++i) {
            lRecentEnergy += (int)((double)this.recentEnergy[i] * 100.0 / (double)(this.recentEnergy.length - 1));
        }
        iCrafting.func_71112_a(container, 0, requiredEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 2, requiredEnergy >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }

    @Override
    public boolean isActive() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public float getStoredEnergy() {
        return this.energyStored;
    }

    public float getRequiredEnergy() {
        return this.currentRequiredEnergy;
    }

    @Override
    public boolean hasCurrentWork() {
        return this.currentRecipe != null;
    }

    @Override
    public int getXCoord() {
        return this.field_70329_l;
    }

    @Override
    public int getYCoord() {
        return this.field_70330_m;
    }

    @Override
    public int getZCoord() {
        return this.field_70327_n;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public static class SelectionMessage {
        public boolean select;
        public ItemStack stack;

        public NBTTagCompound getNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("s", this.select);
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.stack.func_77955_b(itemNBT);
            nbt.func_74766_a("i", itemNBT);
            return nbt;
        }

        public void fromNBT(NBTTagCompound nbt) {
            this.select = nbt.func_74767_n("s");
            NBTTagCompound itemNBT = nbt.func_74775_l("i");
            this.stack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
        }
    }
}

