/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class EnergyPulser {
    private final IPowerReceptor powerReceptor;
    private boolean isActive;
    private boolean singlePulse;
    private boolean hasPulsed;
    private int pulseCount;
    private int tick;

    public EnergyPulser(IPowerReceptor receptor) {
        this.powerReceptor = receptor;
    }

    public void update() {
        if (!this.isActive && this.hasPulsed) {
            this.hasPulsed = false;
        }
        if (this.powerReceptor == null || !this.isActive || this.tick++ % 10 != 0) {
            return;
        }
        if (!this.singlePulse || !this.hasPulsed) {
            this.powerReceptor.getPowerProvider().receiveEnergy(Math.min(1 << this.pulseCount - 1, 64), ForgeDirection.WEST);
            this.hasPulsed = true;
        }
    }

    public void enableSinglePulse(int count) {
        this.singlePulse = true;
        this.isActive = true;
        this.pulseCount = count;
    }

    public void enablePulse(int count) {
        this.isActive = true;
        this.singlePulse = false;
        this.pulseCount = count;
    }

    public void disablePulse() {
        if (!this.isActive) {
            this.hasPulsed = false;
        }
        this.isActive = false;
        this.pulseCount = 0;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("SinglePulse", this.singlePulse);
        nbttagcompound.func_74757_a("IsActive", this.isActive);
        nbttagcompound.func_74757_a("hasPulsed", this.hasPulsed);
        nbttagcompound.func_74768_a("pulseCount", this.pulseCount);
        nbttagcompound.func_74768_a("tick", this.tick);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.isActive = nbttagcompound.func_74767_n("IsActive");
        this.singlePulse = nbttagcompound.func_74767_n("SinglePulse");
        this.hasPulsed = nbttagcompound.func_74767_n("hasPulsed");
        this.pulseCount = nbttagcompound.func_74762_e("pulseCount");
        this.tick = nbttagcompound.func_74762_e("tick");
    }
}

