/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    private static final short MAX_DISPLAY = 100;
    private static final int DISPLAY_SMOOTHING = 10;
    private static final int OVERLOAD_TICKS = 60;
    public static final Map powerCapacities = new HashMap();
    private boolean needsInit = true;
    private TileEntity[] tiles = new TileEntity[6];
    public double[] displayPower = new double[6];
    public double[] prevDisplayPower = new double[6];
    public short[] clientDisplayPower = new short[6];
    public int overload;
    public int[] powerQuery = new int[6];
    public int[] nextPowerQuery = new int[6];
    public long currentDate;
    public double[] internalPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double[] internalNextPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public int maxPower = 8;
    SafeTimeTracker tracker = new SafeTimeTracker();

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
    }

    public void initFromPipe(Class pipeClass) {
        this.maxPower = (Integer)powerCapacities.get(pipeClass);
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof TileGenericPipe && BlockGenericPipe.isValid(pipe2 = ((TileGenericPipe)tile).pipe) && !(pipe2.transport instanceof PipeTransportPower)) {
            return false;
        }
        return tile instanceof TileGenericPipe || tile instanceof IMachine || tile instanceof IPowerReceptor;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateTiles();
    }

    private void updateTiles() {
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = this.container.getTile(ForgeDirection.VALID_DIRECTIONS[i]);
            if (Utils.checkPipesConnections(tile, this.container)) {
                this.tiles[i] = tile;
                continue;
            }
            this.tiles[i] = null;
            this.internalPower[i] = 0.0;
            this.internalNextPower[i] = 0.0;
            this.displayPower[i] = 0.0;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            this.updateTiles();
        }
    }

    @Override
    public void updateEntity() {
        int i;
        int i2;
        if (CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            return;
        }
        this.step();
        this.init();
        System.arraycopy(this.displayPower, 0, this.prevDisplayPower, 0, 6);
        Arrays.fill(this.displayPower, 0.0);
        for (int i3 = 0; i3 < 6; ++i3) {
            int j;
            if (!(this.internalPower[i3] > 0.0)) continue;
            double totalPowerQuery = 0.0;
            for (j = 0; j < 6; ++j) {
                if (j == i3 || this.powerQuery[j] <= 0 || !(this.tiles[j] instanceof TileGenericPipe) && !(this.tiles[j] instanceof IPowerReceptor)) continue;
                totalPowerQuery += (double)this.powerQuery[j];
            }
            for (j = 0; j < 6; ++j) {
                IPowerReceptor pow;
                if (j == i3 || this.powerQuery[j] <= 0) continue;
                double watts = 0.0;
                if (this.tiles[j] instanceof TileGenericPipe) {
                    watts = this.internalPower[i3] / totalPowerQuery * (double)this.powerQuery[j];
                    TileGenericPipe nearbyTile = (TileGenericPipe)this.tiles[j];
                    PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
                    watts = nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[j].getOpposite(), watts);
                    int n = i3;
                    this.internalPower[n] = this.internalPower[n] - watts;
                } else if (this.tiles[j] instanceof IPowerReceptor && (pow = (IPowerReceptor)this.tiles[j]).powerRequest(ForgeDirection.VALID_DIRECTIONS[j].getOpposite()) > 0) {
                    watts = this.internalPower[i3] / totalPowerQuery * (double)this.powerQuery[j];
                    IPowerProvider prov = pow.getPowerProvider();
                    if (prov != null) {
                        prov.receiveEnergy((float)watts, ForgeDirection.VALID_DIRECTIONS[j].getOpposite());
                        int n = i3;
                        this.internalPower[n] = this.internalPower[n] - watts;
                    }
                }
                int n = j;
                this.displayPower[n] = this.displayPower[n] + watts;
                int n2 = i3;
                this.displayPower[n2] = this.displayPower[n2] + watts;
            }
        }
        double highestPower = 0.0;
        for (i2 = 0; i2 < 6; ++i2) {
            this.displayPower[i2] = (this.prevDisplayPower[i2] * 9.0 + this.displayPower[i2]) / 10.0;
            if (!(this.displayPower[i2] > highestPower)) continue;
            highestPower = this.displayPower[i2];
        }
        this.overload += highestPower > (double)this.maxPower * 0.95 ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (i2 = 0; i2 < 6; ++i2) {
            IPowerReceptor receptor;
            int request;
            if (!(this.tiles[i2] instanceof IPowerReceptor) || this.tiles[i2] instanceof TileGenericPipe || (request = (receptor = (IPowerReceptor)this.tiles[i2]).powerRequest(ForgeDirection.VALID_DIRECTIONS[i2].getOpposite())) <= 0) continue;
            this.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i2], request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof TileGenericPipe)) continue;
            TileGenericPipe nearbyTile = (TileGenericPipe)entity;
            if (nearbyTile.pipe == null) continue;
            PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.worldObj, 2 * BuildCraftCore.updateFactor)) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.xCoord, this.yCoord, this.zCoord);
            double displayFactor = 0.09765625;
            for (int i4 = 0; i4 < this.clientDisplayPower.length; ++i4) {
                this.clientDisplayPower[i4] = (short)(this.displayPower[i4] * displayFactor + 0.9999);
            }
            packet.displayPower = this.clientDisplayPower;
            packet.overload = this.isOverloaded();
            CoreProxy.proxy.sendToPlayers(packet.getPacket(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    public void step() {
        if (this.currentDate != this.worldObj.func_72820_D()) {
            this.currentDate = this.worldObj.func_72820_D();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            double[] next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }
    }

    public double receiveEnergy(ForgeDirection from, double val) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            return ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val);
        }
        int n = from.ordinal();
        this.internalNextPower[n] = this.internalNextPower[n] + val;
        if (this.internalNextPower[from.ordinal()] > (double)this.maxPower) {
            val -= this.internalNextPower[from.ordinal()] - (double)this.maxPower;
            this.internalNextPower[from.ordinal()] = this.maxPower;
        }
        return val;
    }

    public void requestEnergy(ForgeDirection from, int amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.worldObj.func_72820_D();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.func_74762_e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.func_74762_e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.func_74769_h("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.func_74769_h("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74768_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74780_a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.func_74780_a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.clientDisplayPower = packetPower.displayPower;
        this.overload = packetPower.overload ? 60 : 0;
    }

    static {
        powerCapacities.put(PipePowerCobblestone.class, 8);
        powerCapacities.put(PipePowerStone.class, 16);
        powerCapacities.put(PipePowerWood.class, 32);
        powerCapacities.put(PipePowerQuartz.class, 64);
        powerCapacities.put(PipePowerGold.class, 256);
        powerCapacities.put(PipePowerDiamond.class, 1024);
    }
}

