/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicObsidian;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsObsidian
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider;
    private int[] entitiesDropped = new int[32];
    private int entitiesDroppedIndex = 0;

    public PipeItemsObsidian(int itemID) {
        super(new PipeTransportItems(), new PipeLogicObsidian(), itemID);
        for (int i = 0; i < this.entitiesDropped.length; ++i) {
            this.entitiesDropped[i] = -1;
        }
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 1, 64, 1, 256);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 16;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.field_70128_L) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    private AxisAlignedBB getSuckingBox(ForgeDirection orientation, int distance) {
        if (orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        Position p1 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        Position p2 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        switch (orientation) {
            case EAST: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case WEST: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case UP: 
            case DOWN: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case SOUTH: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            default: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case EAST: 
            case WEST: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case UP: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case DOWN: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            default: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    @Override
    public void doWork() {
        for (int j = 1; j < 5; ++j) {
            if (!this.trySucc(j)) continue;
            return;
        }
        this.powerProvider.useEnergy(1.0f, 1.0f, true);
    }

    private boolean trySucc(int distance) {
        AxisAlignedBB box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List list = this.worldObj.func_72872_a(Entity.class, box);
        for (int g = 0; g < list.size(); ++g) {
            ItemStack stack;
            if (!(list.get(g) instanceof Entity)) continue;
            Entity entity = (Entity)list.get(g);
            if (this.canSuck(entity, distance)) {
                this.pullItemIntoPipe(entity, distance);
                return true;
            }
            if (distance != 1 || !(list.get(g) instanceof EntityMinecartChest)) continue;
            EntityMinecartChest cart = (EntityMinecartChest)list.get(g);
            if (cart.field_70128_L || (stack = this.checkExtractGeneric((IInventory)cart, true, this.getOpenOrientation())) == null || this.powerProvider.useEnergy(1.0f, 1.0f, true) != 1.0f) continue;
            EntityItem entityitem = new EntityItem(this.worldObj, cart.field_70165_t, cart.field_70163_u + (double)0.3f, cart.field_70161_v, stack);
            entityitem.field_70293_c = 10;
            this.worldObj.func_72838_d((Entity)entityitem);
            this.pullItemIntoPipe((Entity)entityitem, 1);
            return true;
        }
        return false;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int k = 0; k < inventory.func_70302_i_(); ++k) {
            ItemStack slot;
            if (inventory.func_70301_a(k) == null || inventory.func_70301_a((int)k).field_77994_a <= 0 || (slot = inventory.func_70301_a(k)) == null || slot.field_77994_a <= 0) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, 1);
            }
            return slot;
        }
        return null;
    }

    public void pullItemIntoPipe(Entity entity, int distance) {
        if (CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            return;
        }
        ForgeDirection orientation = this.getOpenOrientation().getOpposite();
        if (orientation != ForgeDirection.UNKNOWN) {
            this.worldObj.func_72956_a(entity, "random.pop", 0.2f, ((this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ItemStack stack = null;
            double speed = 0.01f;
            if (entity instanceof EntityItem) {
                EntityItem item = (EntityItem)entity;
                ItemStack contained = item.func_92059_d();
                CoreProxy.proxy.obsidianPipePickup(this.worldObj, item, this.container);
                float energyUsed = this.powerProvider.useEnergy(distance, contained.field_77994_a * distance, true);
                if (distance == 0 || energyUsed / (float)distance == (float)contained.field_77994_a) {
                    stack = contained;
                    CoreProxy.proxy.removeEntity(entity);
                } else {
                    stack = contained.func_77979_a((int)(energyUsed / (float)distance));
                }
                speed = Math.sqrt(item.field_70159_w * item.field_70159_w + item.field_70181_x * item.field_70181_x + item.field_70179_y * item.field_70179_y);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof EntityArrow) {
                this.powerProvider.useEnergy(distance, distance, true);
                stack = new ItemStack(Item.field_77704_l, 1);
                CoreProxy.proxy.removeEntity(entity);
            }
            EntityPassiveItem passive = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(stack), (double)this.zCoord + 0.5, stack);
            passive.setSpeed((float)speed);
            ((PipeTransportItems)this.transport).entityEntering(passive, orientation);
        }
    }

    @Override
    public void onDropped(EntityItem item) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = item.field_70157_k;
    }

    public boolean canSuck(Entity entity, int distance) {
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.func_92059_d().field_77994_a <= 0) {
                return false;
            }
            for (int i = 0; i < this.entitiesDropped.length; ++i) {
                if (item.field_70157_k != this.entitiesDropped[i]) continue;
                return false;
            }
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        if (entity instanceof EntityArrow) {
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

