/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class FacadeMatrix {
    private final int[] _blockIds = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private final int[] _blockMetas = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean dirty = false;

    public void setFacade(ForgeDirection direction, int blockId, int blockMeta) {
        if (this._blockIds[direction.ordinal()] != blockId || this._blockMetas[direction.ordinal()] != blockMeta) {
            this._blockIds[direction.ordinal()] = blockId;
            this._blockMetas[direction.ordinal()] = blockMeta;
            this.dirty = true;
        }
    }

    public int getFacadeBlockId(ForgeDirection direction) {
        return this._blockIds[direction.ordinal()];
    }

    public int getFacadeMetaId(ForgeDirection direction) {
        return this._blockMetas[direction.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void readData(DataInputStream data) throws IOException {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this._blockIds[i] = data.readInt();
            this._blockMetas[i] = data.readInt();
        }
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.writeInt(this._blockIds[i]);
            data.writeInt(this._blockMetas[i]);
        }
    }
}

