/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.core.gui.GuiWidget;
import codechicken.core.inventory.GuiContainerWidget;
import codechicken.core.render.FontUtils;
import codechicken.nei.ContainerPotionCreator;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class GuiPotionCreator
extends GuiContainerWidget {
    int amplifier = 0;
    GuiCCButton ampDown;
    GuiCCButton ampUp;
    GuiSlotPotionEffects slotPotionEffects;
    GuiDurationField durationField;
    ContainerPotionCreator container = (ContainerPotionCreator)this.d;

    public GuiPotionCreator(so inventoryplayer) {
        super((tj)new ContainerPotionCreator(inventoryplayer, (lt)new ContainerPotionCreator.InventoryPotionStore()), 176, 208);
    }

    public void applyEffect() {
        if (this.slotPotionEffects.selectedslot >= 0) {
            this.container.setPotionEffect(this.slotPotionEffects.selectedPotion(), this.durationField.getDurationTicks(), this.amplifier);
        }
    }

    public String translateAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return Integer.toString(amplifier);
    }

    public void validateInputButtons() {
        this.ampDown.setEnabled(this.amplifier > 0);
        this.ampUp.setEnabled(this.amplifier < 3);
    }

    protected void b(int par1, int par2) {
    }

    public void drawBackground() {
        this.g.p.b("/codechicken/nei/potion.png");
        this.b(0, 0, 0, 0, this.b, this.c);
        FontUtils.drawCenteredString((String)"Favourite Potions", (int)(this.b / 2), (int)4, (int)0x404040);
        this.m.b("Duration", 12, 40, 0x404040);
        this.m.b("Level", 19, 73, 0x404040);
        FontUtils.drawCenteredString((String)this.translateAmplifier(this.amplifier), (int)33, (int)86, (int)-10461088);
    }

    public void addWidgets() {
        this.ampDown = new GuiCCButton(10, 84, 12, 12, "<").setActionCommand("ampDown");
        this.add((GuiWidget)this.ampDown);
        this.ampUp = new GuiCCButton(44, 84, 12, 12, ">").setActionCommand("ampUp");
        this.add((GuiWidget)this.ampUp);
        this.durationField = new GuiDurationField(15, 53, 35, 12);
        this.add((GuiWidget)this.durationField);
        this.slotPotionEffects = new GuiSlotPotionEffects(60, 38);
        this.add((GuiWidget)this.slotPotionEffects);
    }

    public void c() {
        super.c();
        this.slotPotionEffects.setEnabled(this.container.potionInv.a(0) != null);
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("ampDown")) {
            --this.amplifier;
        } else if (ident.equals("ampUp")) {
            ++this.amplifier;
        }
        this.applyEffect();
        this.validateInputButtons();
    }

    public class GuiDurationField
    extends GuiCCTextField {
        private String baseValue;

        public GuiDurationField(int x, int y, int width, int height) {
            super(x, y, width, height, "100");
            this.setMaxStringLength(4);
            this.setAllowedCharacters("0123456789");
            this.baseValue = this.getText();
        }

        public void setDurationTicks(int i) {
            String minutes = Integer.toString((i /= 20) / 60);
            String seconds = Integer.toString(i % 60);
            if (seconds.length() == 1) {
                seconds = String.valueOf('0') + seconds;
            }
            this.setText(String.valueOf(minutes) + seconds);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!this.isEnabled()) {
                this.setText("100");
            }
        }

        public void onFocusChanged() {
            if (this.isFocused()) {
                this.baseValue = this.getText();
            } else if (!this.validateValue()) {
                this.setText(this.baseValue);
            } else {
                GuiPotionCreator.this.applyEffect();
            }
        }

        public void onTextChanged(String oldText) {
            GuiPotionCreator.this.validateInputButtons();
        }

        private boolean validateValue() {
            try {
                int i = Integer.parseInt(this.getText());
                return i > 1 && this.getDurationTicks() < Short.MAX_VALUE && i / 100 <= 60 && i % 100 < 60;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        public void drawText() {
            String s = this.getText();
            String seconds = s.substring(Math.max(0, s.length() - 2), Math.max(0, s.length() - 2) + Math.min(s.length(), 2));
            String minutes = s.length() < 3 ? "" : s.substring(0, s.length() - 2);
            int ty = this.y + this.height / 2 - 4;
            int tcolour = this.getTextColour();
            FontUtils.drawCenteredString((String)":", (int)(this.x + this.width / 2 + 1), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)seconds, (int)(this.x + this.width - 3), (int)ty, (int)tcolour);
            FontUtils.drawRightString((String)minutes, (int)(this.x + this.width / 2 - 1), (int)ty, (int)tcolour);
        }

        public int getTextColour() {
            return this.isFocused() ? 0xCCCCCC : 0x909090;
        }

        public int getDurationTicks() {
            int i = Integer.parseInt(this.getText());
            return (i / 100 * 60 + i % 100) * 20;
        }
    }

    public class GuiSlotPotionEffects
    extends GuiScrollSlot {
        public int selectedslot;
        public boolean enabled;
        private ArrayList validPotions;

        public GuiSlotPotionEffects(int x, int y) {
            super(x, y, 108, 76);
            this.selectedslot = -1;
            this.enabled = true;
            this.validPotions = new ArrayList();
            mk[] mkArray = mk.a;
            int n = mk.a.length;
            int n2 = 0;
            while (n2 < n) {
                mk p = mkArray[n2];
                if (p != null) {
                    this.validPotions.add(p);
                }
                ++n2;
            }
            this.setSmoothScroll(false);
            this.setContentSize(x, y, this.height);
        }

        public int getSlotHeight() {
            return 19;
        }

        public void drawSlotBox() {
            GuiSlotPotionEffects.a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        }

        public void drawOverlay() {
        }

        public boolean drawLineGuide() {
            return false;
        }

        public int getScrollBarWidth() {
            return 7;
        }

        protected void drawSlot(int slot, int x, int y, int mx, int my, boolean selected) {
            int textColour;
            String amp;
            boolean blank;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mk potion = (mk)this.validPotions.get(slot);
            ml effect = this.getEffect(potion.H);
            boolean bl = blank = effect == null;
            if (effect == null) {
                effect = new ml(potion.H, 1200, 0);
            }
            int shade = this.selectedslot == slot ? 2 : (blank ? 1 : 0);
            GuiPotionCreator.this.g.p.b("/gui/enchant.png");
            this.b(x, y, 0, 166 + this.getSlotHeight() * shade, this.width - 30, this.getSlotHeight());
            this.b(x + this.width - 30, y, this.width - 23, 166 + this.getSlotHeight() * shade, 30, this.getSlotHeight());
            if (potion.d()) {
                GuiPotionCreator.this.g.p.b("/gui/inventory.png");
                int icon = potion.e();
                this.b(x + 1, y + 1, 0 + icon % 8 * 18, 198 + icon / 8 * 18, 18, 18);
            }
            String name = bo.a((String)potion.a());
            String string = amp = effect.c() > 0 ? " " + GuiPotionCreator.this.translateAmplifier(effect.c()) : "";
            int n = shade == 0 ? 6839882 : (textColour = shade == 1 ? 4226832 : 0xFFFF80);
            if (this.fontRenderer.a(String.valueOf(name) + amp) < this.width - 20) {
                this.fontRenderer.b(String.valueOf(name) + amp, x + 20, y + 1, textColour);
            } else {
                this.fontRenderer.b(name, x + 20, y + 1, textColour);
                FontUtils.drawRightString((String)amp, (int)(x + this.width - 10), (int)(y + 10), (int)textColour);
            }
            String duration = mk.a((ml)effect);
            textColour = shade == 0 ? 0xA0A0A0 : (shade == 1 ? 0x808080 : 0xCCCCCC);
            this.fontRenderer.a(duration, x + 20, y + 10, textColour);
        }

        private ml getEffect(int id) {
            wm potion = GuiPotionCreator.this.container.potionInv.a(0);
            if (potion != null && potion.p() && potion.q().b("CustomPotionEffects")) {
                ca potionTagList = potion.q().m("CustomPotionEffects");
                int i = 0;
                while (i < potionTagList.c()) {
                    ml effect = ml.b((bs)((bs)potionTagList.b(i)));
                    if (effect.a() == id) {
                        return effect;
                    }
                    ++i;
                }
            }
            return null;
        }

        protected int getNumSlots() {
            return this.validPotions.size();
        }

        protected boolean isSlotSelected(int slot) {
            return slot == this.selectedslot;
        }

        protected void slotClicked(int slot, int button, int mx, int my, boolean doubleclick) {
            if (!this.enabled) {
                return;
            }
            if (button == 0) {
                this.select(slot);
                GuiPotionCreator.this.applyEffect();
            } else if (button == 1) {
                this.deselect();
                GuiPotionCreator.this.container.removePotionEffect(((mk)this.validPotions.get((int)slot)).H);
            }
        }

        public void selectNext() {
            if (this.selectedslot >= 0 && this.selectedslot + 1 < this.getNumSlots()) {
                this.select(this.selectedslot + 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void selectPrev() {
            if (this.selectedslot > 0) {
                this.select(this.selectedslot - 1);
                this.showSlot(this.selectedslot);
            }
        }

        public void setEnabled(boolean b) {
            if (b == this.enabled) {
                return;
            }
            this.enabled = b;
            if (!this.enabled) {
                this.deselect();
            }
        }

        private void select(int slot) {
            this.selectedslot = slot;
            GuiPotionCreator.this.durationField.setEnabled(true);
            ml effect = this.getEffect(((mk)this.validPotions.get((int)slot)).H);
            if (effect == null) {
                effect = new ml(((mk)this.validPotions.get((int)slot)).H, 1200, 0);
            }
            GuiPotionCreator.this.durationField.setDurationTicks(effect.b());
            GuiPotionCreator.this.amplifier = effect.c();
            GuiPotionCreator.this.validateInputButtons();
        }

        private void deselect() {
            this.selectedslot = -1;
            GuiPotionCreator.this.durationField.setEnabled(false);
            GuiPotionCreator.this.ampDown.setEnabled(false);
            GuiPotionCreator.this.ampUp.setEnabled(false);
        }

        public int selectedPotion() {
            return ((mk)this.validPotions.get((int)this.selectedslot)).H;
        }
    }
}

