/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.core.inventory.ItemKey;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.GuiPotionCreator;
import codechicken.nei.InterActionMap;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.forge.GuiContainerManager;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class NEICPH
implements PacketCustom.IClientPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, bdk nethandler, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUnsignedByte(), packet.readString(), (aab)mc.e);
                break;
            }
            case 6: {
                NEIClientConfig.setMagnetMode(packet.readBoolean());
                break;
            }
            case 7: {
                NEIClientConfig.setCreativeMode(packet.readUnsignedByte());
                break;
            }
            case 10: {
                this.handlePermissableActions(packet);
                break;
            }
            case 11: {
                this.handleBannedBlocks(packet);
                break;
            }
            case 12: {
                this.handleDisabledProperties(packet);
                break;
            }
            case 13: {
                ClientHandler.instance().addSMPMagneticItem(packet.readInt(), (aab)mc.e);
                break;
            }
            case 21: {
                ClientUtils.openSMPGui((int)packet.readUnsignedByte(), (axr)new GuiEnchantmentModifier(mc.g.bK, (aab)mc.e, 0, 0, 0));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui((int)packet.readUnsignedByte(), (axr)new GuiExtendedCreativeInv(new ContainerCreativeInv((sq)mc.g, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.a((axr)new azg((sq)mc.g));
                break;
            }
            case 24: {
                ClientUtils.openSMPGui((int)packet.readUnsignedByte(), (axr)new GuiPotionCreator(mc.g.bK));
            }
        }
    }

    private void handleDisabledProperties(PacketCustom packet) {
        NEIClientConfig.resetDisabledProperties();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIClientConfig.setPropertyDisabled(packet.readUnsignedByte());
            ++i;
        }
    }

    private void handleBannedBlocks(PacketCustom packet) {
        int num = packet.readInt();
        ArrayList<ItemKey> items = new ArrayList<ItemKey>(num);
        int i = 0;
        while (i < num) {
            items.add(new ItemKey(packet.readUnsignedShort(), packet.readUnsignedShort()));
            ++i;
        }
        NEIClientConfig.setBannedBlocks(items);
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handlePermissableActions(PacketCustom packet) {
        NEIClientConfig.resetPermissableActions();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIClientConfig.addPermissableAction(InterActionMap.values()[packet.readUnsignedByte()]);
            ++i;
        }
    }

    private void handleSMPCheck(int serverprotocol, String worldName, aab world) {
        if (serverprotocol > 5) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Client");
        } else if (serverprotocol < 5) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Server");
        } else {
            try {
                String prefx;
                if (ClientUtils.isLocal()) {
                    prefx = "local";
                    worldName = ClientUtils.getWorldSaveName((String)worldName);
                } else {
                    prefx = "remote/" + ClientUtils.getServerIP().replace(':', '~');
                }
                NEIClientConfig.loadWorld(String.valueOf(prefx) + '/' + worldName);
                NEIClientConfig.setHasSMPCounterPart(true);
                NEICPH.sendRequestLoginInfo();
            }
            catch (Exception nce) {
                nce.printStackTrace();
            }
        }
    }

    public static void sendSpawnItem(wm spawnstack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        List name = GuiContainerManager.itemDisplayNameMultiline(spawnstack, null, false);
        packet.writeByte(name.size());
        for (String s : name) {
            packet.writeString(s);
        }
        packet.writeItemStack(spawnstack);
        packet.writeInt(spawnstack.a);
        packet.sendToServer();
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom((Object)channel, 4);
        packet.sendToServer();
    }

    public static void sendStateLoad(wm[] state) {
        NEICPH.sendDeleteAllItems();
        int slot = 0;
        while (slot < state.length) {
            wm item = state[slot];
            if (item != null) {
                NEICPH.sendSetSlot(slot, item, false);
            }
            ++slot;
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.sendToServer();
    }

    public static void sendSetSlot(int slot, wm stack, boolean container) {
        PacketCustom packet = new PacketCustom((Object)channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.sendToServer();
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.sendToServer();
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(hour);
        packet.sendToServer();
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom((Object)channel, 8);
        packet.sendToServer();
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom((Object)channel, 9);
        packet.sendToServer();
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom((Object)channel, 21);
        packet.sendToServer();
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom((Object)channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        packet.sendToServer();
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeByte(((Integer)AllowedPropertyMap.nameToIDMap.get(name)).intValue());
        packet.writeBoolean(enable);
        packet.sendToServer();
    }

    public static void sendCycleCreativeMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        packet.sendToServer();
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 23);
        packet.writeBoolean(open);
        packet.sendToServer();
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom((Object)channel, 14);
        packet.writeInt(steps);
        packet.sendToServer();
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom((Object)channel, 15);
        packet.writeCoord(x, y, z);
        packet.writeString(mobtype);
        packet.sendToServer();
    }

    public static PacketCustom createContainerPacket() {
        return new PacketCustom((Object)channel, 20);
    }

    public static void sendOpenPotionWindow() {
        wm[] potionStore = new wm[9];
        InventoryUtils.readItemStacksFromTag((wm[])potionStore, (ca)NEIClientConfig.saveCompound.l("potionStore").m("items"));
        PacketCustom packet = new PacketCustom((Object)channel, 24);
        int i = 0;
        while (i < potionStore.length) {
            packet.writeItemStack(potionStore[i]);
            ++i;
        }
        packet.sendToServer();
    }

    public static void sendDummySlotSet(int slotNumber, wm stack) {
        PacketCustom packet = new PacketCustom((Object)channel, 25);
        packet.writeShort(slotNumber);
        packet.writeItemStack(stack, true);
        packet.sendToServer();
    }
}

