/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.List;

public class ServerHandler
implements ITickHandler,
IPlayerTracker {
    private static ServerHandler instance;

    public static void load() {
        instance = new ServerHandler();
        PacketCustom.assignHandler((String)"NEI", (int)0, (int)255, (PacketCustom.ICustomPacketHandler)new NEISPH());
        TickRegistry.registerTickHandler((ITickHandler)instance, (Side)Side.SERVER);
        GameRegistry.registerPlayerTracker((IPlayerTracker)instance);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            this.processDisabledProperties((aab)tickData[0]);
        }
        if (type.contains(TickType.WORLDLOAD)) {
            NEIServerConfig.load((aab)tickData[0]);
        }
        if (type.contains(TickType.PLAYER)) {
            jc player = (jc)tickData[0];
            PlayerSave save = NEIServerConfig.forPlayer(player.bS);
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            this.updateOpChange(player, save);
            save.save();
        }
    }

    private void updateOpChange(jc player, PlayerSave save) {
        boolean isOp = ServerUtils.isPlayerOP((String)save.username);
        if (isOp != save.wasOp) {
            NEISPH.sendHasServerSideTo(player);
            save.wasOp = isOp;
        }
    }

    private void processDisabledProperties(aab world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isPropertyDisabled(CommonUtils.getDimension((aab)world), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(jc player, PlayerSave save) {
        if (!save.getMagnetMode() || player.M) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.q.a(rh.class, player.E.b((double)distancexz, (double)distancey, (double)distancexz));
        for (rh item : items) {
            double rationspeedy;
            if (item.b > 0 || !NEIServerUtils.canItemFitInInventory((sq)player, item.d())) continue;
            if (item.b == 0) {
                NEISPH.sendAddMagneticItemTo(player, item);
            }
            double dx = player.u - item.u;
            double dy = player.v + (double)player.e() - item.v;
            double dz = player.w - item.w;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.b_((sq)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.x + speedxz * dx;
            double vy = item.y + speedy * dy;
            double vz = item.z + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            item.x = vx;
            item.y = vy;
            item.z = vz;
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.PLAYER, TickType.WORLDLOAD);
    }

    public String getLabel() {
        return "NEI Server";
    }

    public void onPlayerLogin(sq player) {
        NEIServerConfig.loadPlayer(player);
        NEISPH.sendHasServerSideTo((jc)player);
    }

    public void onPlayerLogout(sq player) {
        NEIServerConfig.unloadPlayer(player);
    }

    public void onPlayerChangedDimension(sq player) {
        NEISPH.sendHasServerSideTo((jc)player);
    }

    public void onPlayerRespawn(sq player) {
        NEISPH.sendHasServerSideTo((jc)player);
    }
}

