/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends acn>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, iz> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<aab, aab> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static boolean registerProviderType(int id, Class<? extends acn> provider, boolean keepLoaded) {
        if (providers.containsKey(id)) {
            return false;
        }
        providers.put(id, provider);
        spawnSettings.put(id, keepLoaded);
        return true;
    }

    public static int[] unregisterProviderType(int id) {
        if (!providers.containsKey(id)) {
            return new int[0];
        }
        providers.remove(id);
        spawnSettings.remove(id);
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Map.Entry<Integer, Integer> ent : dimensions.entrySet()) {
            if (ent.getValue() != id) continue;
            ret[x++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerProviderType(0, acp.class, true);
        DimensionManager.registerProviderType(-1, aco.class, true);
        DimensionManager.registerProviderType(1, acq.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id, providerType));
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, providerType);
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static acn getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).t;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                aab w = (aab)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (aab w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurences).\n", System.identityHashCode(w), w.M().k());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times.\n", System.identityHashCode(w), w.M().k(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, iz world) {
        if (world != null) {
            worlds.put(id, world);
            weakWorldMap.put(world, world);
            MinecraftServer.D().worldTickTimes.put(id, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id, world.M().k(), world.p());
        } else {
            worlds.remove(id);
            MinecraftServer.D().worldTickTimes.remove(id);
            FMLLog.info("Unloading dimension %d", id);
        }
        ArrayList<iz> tmp = new ArrayList<iz>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, iz> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.D().b = tmp.toArray(new iz[tmp.size()]);
    }

    public static void initDimension(int dim) {
        iz overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.p();
        akf savehandler = overworld.L();
        aai worldSettings = new aai(overworld.M());
        iz world = dim == 0 ? overworld : new is(mcServer, savehandler, overworld.M().k(), dim, worldSettings, overworld, mcServer.a, overworld.X());
        world.a((aag)new iv(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.I()) {
            world.M().a(mcServer.g());
        }
        mcServer.c(mcServer.h());
    }

    public static iz getWorld(int id) {
        return worlds.get(id);
    }

    public static iz[] getWorlds() {
        return worlds.values().toArray(new iz[worlds.size()]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id = DimensionManager.getProviderType(dim);
        return spawnSettings.containsKey(id) && spawnSettings.get(id) != false;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static acn createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                acn provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), e);
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id) {
        unloadQueue.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id : unloadQueue) {
            iz w = worlds.get(id);
            try {
                if (w != null) {
                    w.a(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id);
            }
            catch (aaf e) {
                e.printStackTrace();
            }
            finally {
                if (w == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w));
                w.n();
                DimensionManager.setWorld(id, null);
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static bs saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        bs dimMap = new bs();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i * 32 + j2) ? 1 << j2 : 0;
            }
            data[i] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(bs compoundTag) {
        if (compoundTag == null) {
            dimensionMap.clear();
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.k("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i * 32 + j2, (intArray[i] & 1 << j2) != 0);
                }
            }
        }
    }

    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return ((ajt)DimensionManager.getWorld(0).L()).b();
        }
        if (MinecraftServer.D() != null) {
            MinecraftServer srv = MinecraftServer.D();
            ajt saveHandler = (ajt)srv.N().a(srv.J(), false);
            return saveHandler.b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

