/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;

public class LiquidStack {
    public final int itemID;
    public int amount;
    public final int itemMeta;
    public bs extra;
    private String textureSheet = "/terrain.png";
    @SideOnly(value=Side.CLIENT)
    private lx renderingIcon;

    public LiquidStack(int itemID, int amount) {
        this(itemID, amount, 0);
    }

    public LiquidStack(wk item, int amount) {
        this(item.cp, amount, 0);
    }

    public LiquidStack(apa block, int amount) {
        this(block.cz, amount, 0);
    }

    public LiquidStack(int itemID, int amount, int itemDamage) {
        this.itemID = itemID;
        this.amount = amount;
        this.itemMeta = itemDamage;
    }

    public LiquidStack(int itemID, int amount, int itemDamage, bs nbt) {
        this(itemID, amount, itemDamage);
        if (nbt != null) {
            this.extra = (bs)nbt.b();
        }
    }

    public bs writeToNBT(bs nbt) {
        nbt.a("Amount", this.amount);
        nbt.a("Id", (short)this.itemID);
        nbt.a("Meta", (short)this.itemMeta);
        String name = LiquidDictionary.findLiquidName(this);
        if (name != null) {
            nbt.a("LiquidName", name);
        }
        if (this.extra != null) {
            nbt.a("extra", (cf)this.extra);
        }
        return nbt;
    }

    @Deprecated
    public void readFromNBT(bs nbt) {
    }

    public LiquidStack copy() {
        return new LiquidStack(this.itemID, this.amount, this.itemMeta, this.extra);
    }

    public boolean isLiquidEqual(LiquidStack other) {
        return other != null && this.itemID == other.itemID && this.itemMeta == other.itemMeta && (this.extra == null ? other.extra == null : this.extra.equals((Object)other.extra));
    }

    public boolean containsLiquid(LiquidStack other) {
        return this.isLiquidEqual(other) && this.amount >= other.amount;
    }

    public boolean isLiquidEqual(wm other) {
        if (other == null) {
            return false;
        }
        if (this.itemID == other.c && this.itemMeta == other.k()) {
            return true;
        }
        return this.isLiquidEqual(LiquidContainerRegistry.getLiquidForFilledItem(other));
    }

    public wm asItemStack() {
        wm stack = new wm(this.itemID, 1, this.itemMeta);
        if (this.extra != null) {
            stack.d = (bs)this.extra.b();
        }
        return stack;
    }

    public static LiquidStack loadLiquidStackFromNBT(bs nbt) {
        if (nbt == null) {
            return null;
        }
        String liquidName = nbt.i("LiquidName");
        int itemID = nbt.d("Id");
        int itemMeta = nbt.d("Meta");
        LiquidStack liquid = LiquidDictionary.getCanonicalLiquid(liquidName);
        if (liquid != null) {
            itemID = liquid.itemID;
            itemMeta = liquid.itemMeta;
        } else if (wk.f[itemID] == null) {
            return null;
        }
        int amount = nbt.e("Amount");
        LiquidStack liquidstack = new LiquidStack(itemID, amount, itemMeta);
        if (nbt.b("extra")) {
            liquidstack.extra = nbt.l("extra");
        }
        return liquidstack.itemID == 0 ? null : liquidstack;
    }

    public String getTextureSheet() {
        return this.textureSheet;
    }

    public LiquidStack setTextureSheet(String textureSheet) {
        this.textureSheet = textureSheet;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public lx getRenderingIcon() {
        if (this.itemID == apa.F.cz) {
            return ane.b("water");
        }
        if (this.itemID == apa.H.cz) {
            return ane.b("lava");
        }
        return this.renderingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public LiquidStack setRenderingIcon(lx icon) {
        this.renderingIcon = icon;
        return this;
    }

    public final int hashCode() {
        return 31 * this.itemMeta + this.itemID;
    }

    public final boolean equals(Object ob) {
        if (ob instanceof LiquidStack) {
            LiquidStack ls = (LiquidStack)ob;
            return ls.itemID == this.itemID && ls.itemMeta == this.itemMeta && (this.extra == null ? ls.extra == null : this.extra.equals((Object)ls.extra));
        }
        return false;
    }

    public LiquidStack canonical() {
        return LiquidDictionary.getCanonicalLiquid(this);
    }
}

