/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidTank
implements ILiquidTank {
    private LiquidStack liquid;
    private int capacity;
    private int tankPressure;
    private aqp tile;

    public LiquidTank(int capacity) {
        this(null, capacity);
    }

    public LiquidTank(int liquidId, int quantity, int capacity) {
        this(new LiquidStack(liquidId, quantity), capacity);
    }

    public LiquidTank(int liquidId, int quantity, int capacity, aqp tile) {
        this(liquidId, quantity, capacity);
        this.tile = tile;
    }

    public LiquidTank(LiquidStack liquid, int capacity) {
        this.liquid = liquid;
        this.capacity = capacity;
    }

    public LiquidTank(LiquidStack liquid, int capacity, aqp tile) {
        this(liquid, capacity);
        this.tile = tile;
    }

    @Override
    public LiquidStack getLiquid() {
        return this.liquid;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setLiquid(LiquidStack liquid) {
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.liquid == null || this.liquid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
                if (this.tile != null) {
                    LiquidEvent.fireEvent(new LiquidEvent.LiquidFillingEvent(this.liquid, this.tile.k, this.tile.l, this.tile.m, this.tile.n, this));
                }
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
        }
        return space;
    }

    @Override
    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        if (doDrain && this.tile != null) {
            LiquidEvent.fireEvent(new LiquidEvent.LiquidDrainingEvent(drained, this.tile.k, this.tile.l, this.tile.m, this.tile.n, this));
        }
        return drained;
    }

    @Override
    public int getTankPressure() {
        return this.tankPressure;
    }

    public void setTankPressure(int pressure) {
        this.tankPressure = pressure;
    }

    public String getLiquidName() {
        return this.liquid != null ? LiquidDictionary.findLiquidName(this.liquid) : null;
    }

    public boolean containsValidLiquid() {
        return LiquidDictionary.findLiquidName(this.liquid) != null;
    }

    public bs writeToNBT(bs nbt) {
        if (this.containsValidLiquid()) {
            this.liquid.writeToNBT(nbt);
        } else {
            nbt.a("emptyTank", "");
        }
        return nbt;
    }

    public LiquidTank readFromNBT(bs nbt) {
        LiquidStack liquid;
        if (!nbt.b("emptyTank") && (liquid = LiquidStack.loadLiquidStackFromNBT(nbt)) != null) {
            this.setLiquid(liquid);
        }
        return this;
    }
}

