package net.minecraftforge.legacy._1_5_2;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

import cpw.mods.fml.relauncher.CoreFMLLibraries;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.ILibrarySet;
import cpw.mods.fml.relauncher.RelaunchLibraryManager;

public class LibraryFixerCoremod implements IFMLLoadingPlugin
{
	@Override public String[] getASMTransformerClass(){ return new String[0]; }
	@Override public void injectData(Map<String, Object> data){}
	@Override public String getSetupClass(){ return null; }
	@Override
	public String getModContainerClass()
	{
		return null;
	}

	@Override
	public String[] getLibraryRequestClass()
	{
		try
		{
			Field field = RelaunchLibraryManager.class.getDeclaredField("libraries");
			field.setAccessible(true);
			List<ILibrarySet> libraries = (List<ILibrarySet>)field.get(null);
			ILibrarySet[] libs = libraries.toArray(new ILibrarySet[libraries.size()]);
			for (ILibrarySet lib : libs)
			{
				if (lib.getClass() == CoreFMLLibraries.class)
				{
					FMLRelaunchLog.info("[LegacyFixer] Removing CoreFMLLibraries: " + lib);
					libraries.remove(lib);
				}
				else if (lib.getRootURL().contains("files.minecraftforge.net/fmllibs/"))
				{
					FMLRelaunchLog.info("[LegacyFixer] Removing fmllibs reference: " + lib);
					libraries.remove(lib);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return new String[]{ "net.minecraftforge.legacy._1_5_2.LibraryFixerLibrarySet" };
	}
}
